
package com.agilex.healthcare.veteranappointment.resources;

import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifiers;
import com.agilex.healthcare.veteranappointment.dataservice.PatientPreferenceDataService;
import com.agilex.healthcare.veteranappointment.domain.VARPatientPreference;
import com.agilex.healthcare.veteranappointment.utils.linkbuilder.PatientPreferencesLinkBuilder;
import gov.va.vamf.scheduling.direct.datalayer.appointment.PatientIdentifiersDataService;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import gov.va.vamf.security.v1.filters.JwtResourceRestricted;

import javax.annotation.Resource;
import javax.ws.rs.*;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.UriInfo;

@Path("/patient/{assigning-authority}/{patient-id}/preference")
@Component
@Scope("request")
@JwtResourceRestricted
public class PatientPreferencesResource {

    @Resource
    PatientPreferenceDataService patientPreferenceDataService;

	@Resource
	PatientIdentifiersDataService patientIdentifiersDataService;
    
    /**
     * This REST service is used to fetch patient preferences from SED database
     * @param assigningAuthority
     * @param patientId
     * @param uriInfo
     * @param headers
     * @return VARPatientPreference
     */
	@GET
	@Produces({ "application/xml", "application/json" })
	public VARPatientPreference fetchPatientPreferences(@PathParam("assigning-authority") String assigningAuthority, @PathParam("patient-id") String patientId, @Context UriInfo uriInfo, @Context HttpHeaders headers) {

		PatientIdentifier targetIdentifier = patientIdentifiersDataService.getTargetPatientIdentifier(assigningAuthority, patientId);

        VARPatientPreference patPref = patientPreferenceDataService.fetchPatientPreference(targetIdentifier);
		
		if (uriInfo != null) {
			PatientPreferencesLinkBuilder linkbuilder = new PatientPreferencesLinkBuilder(uriInfo.getBaseUri());
			linkbuilder.fillLinks(patPref, uriInfo.getRequestUri());
		}
		return patPref;
	}
	
	/**
	 * This REST service is used to save/update patient preferences into SED database
	 * @param patPref
	 * @param assigningAuthority
	 * @param patientId
	 * @param uriInfo
	 * @param headers
	 * @return VARPatientPreference
	 */	
	@PUT
	@Produces({ "application/xml", "application/json" })
	@Consumes({ "application/xml", "application/json" })
	public VARPatientPreference updatePatientPreferences(VARPatientPreference patPref, @PathParam("assigning-authority") String assigningAuthority,
			@PathParam("patient-id") String patientId, @Context UriInfo uriInfo, @Context HttpHeaders headers) {

		PatientIdentifier patientIdentifier = new PatientIdentifier(assigningAuthority,patientId);
		PatientIdentifiers allIdentifiers = patientIdentifiersDataService.getCorrespondIdentifiers(patientIdentifier);

		VARPatientPreference updatePatPref = null;
		// Save preference using both EDIPI and ICN
		for( PatientIdentifier identifier : allIdentifiers ) {
			String currAssignAuth = identifier.getAssigningAuthority();
			if( currAssignAuth.equalsIgnoreCase("EDIPI") || currAssignAuth.equalsIgnoreCase("ICN") ) {
				patPref.setPatientIdentifier(identifier);
				updatePatPref = patientPreferenceDataService.updatePatientPreference(patPref);
			}
		}

		if (uriInfo != null) {
			PatientPreferencesLinkBuilder linkBuilder = new PatientPreferencesLinkBuilder(uriInfo.getBaseUri());
			linkBuilder.fillLinks(updatePatPref, uriInfo.getRequestUri());
		}

		return updatePatPref;
	
	}
	
}
